#include "General.h"
#include "Suicide5MinWait.h"
#include "engine_tt.h"
#include "engine_io.h"
#include "gmgame.h"

int LastSuicideTime[128];

void Console(const char *Format, ...)
{
	char buffer[256];
	va_list va;
	_crt_va_start(va, Format);
	vsnprintf(buffer, 256, Format, va);
	va_end(va);
	Console_Input(buffer);
}

Hook *Suicide = new Hook;
 
void __cdecl Suicide_Hook(int PlayerID)
{
	if ((LastSuicideTime[PlayerID] == 0) || (((int)time(NULL) - LastSuicideTime[PlayerID]) > 300))
	{
		Console("MSG %S committed suicide.", Find_Player(PlayerID)->PlayerName);

		// Attach_Script_Once(Get_GameObj(PlayerID), "Suicide5MinWait_Player_Suicide", "");
		Commands->Destroy_Object(Get_GameObj(PlayerID));

		Find_Player(PlayerID)->Set_Money(0.0f);

		LastSuicideTime[PlayerID] = (int)time(NULL);
	}
	else
	{
		int TimeRemaining  = (LastSuicideTime[PlayerID] - (int)time(NULL)) + 300;
		Console("PPAGE %d You are only allowed to suicide every 5 minutes. Please wait %d seconds.", PlayerID, TimeRemaining);
	}
}

void __declspec(naked) Suicide_Glue()
{
	__asm {
		mov eax, [ecx+6B4h]
		push eax
		call Suicide_Hook
		add esp, 4
		ret
	}
}

Suicide5MinWait::Suicide5MinWait()
{
	RegisterEvent(EVENT_LOAD_LEVEL_HOOK,this);
	RegisterEvent(EVENT_PLAYER_LEAVE_HOOK,this);

	Suicide->Install('\xE9', 0x004BA140, (int)&Suicide_Glue, "");
}

Suicide5MinWait::~Suicide5MinWait()
{
	UnregisterEvent(EVENT_LOAD_LEVEL_HOOK,this);
	UnregisterEvent(EVENT_PLAYER_LEAVE_HOOK,this);
}

void Suicide5MinWait::OnLoadLevel()
{
	for (int i = 0; i < 127; i++)
	{
		LastSuicideTime[i] = 0;
	}
}

void Suicide5MinWait::OnPlayerLeave(int PlayerID)
{
	LastSuicideTime[PlayerID] = 0;
}
 
bool Hooking::ReadMemory(int Address, void* Buffer, int Size)
{
	bool ret = 1;
	DWORD OldProtect;
	HANDLE Process = OpenProcess(PROCESS_VM_READ | PROCESS_VM_WRITE | PROCESS_VM_OPERATION, false, GetCurrentProcessId());
	VirtualProtectEx(Process, (LPVOID)Address, Size, PAGE_EXECUTE_READWRITE, &OldProtect);
	if (!ReadProcessMemory(Process, (LPVOID)Address, Buffer, Size, NULL))
	{
		Console_Output("[Suicide5MinWait] Reading process memory failed, this is a non-fatal error.\n");
		Console_Output("GetLastError() = %d\n", GetLastError());
		ret = 0;
	}
	VirtualProtectEx(Process, (LPVOID)Address, Size, OldProtect, NULL);
	CloseHandle(Process);
	return ret;
}
 
bool Hooking::WriteMemory(int Address, const void* Buffer, int Size)
{
	bool ret = 1;
	DWORD OldProtect;
	HANDLE Process = OpenProcess(PROCESS_VM_READ | PROCESS_VM_WRITE | PROCESS_VM_OPERATION, false, GetCurrentProcessId());
	VirtualProtectEx(Process, (LPVOID)Address, Size, PAGE_EXECUTE_READWRITE, &OldProtect);
	if (!WriteProcessMemory(Process, (LPVOID)Address, Buffer, Size, NULL))
	{
		Console_Output("[Suicide5MinWait] Hooking suicides failed, this plugin won't do anything now.\n");
		Console_Output("GetLastError() = %d\n", GetLastError());
		ret = 0;
	}
	VirtualProtectEx(Process, (LPVOID)Address, Size, OldProtect, NULL);
	CloseHandle(Process);
	return ret;
}

Suicide5MinWait suicide5MinWait;

extern "C" __declspec(dllexport) Plugin* Plugin_Init()
{
	return &suicide5MinWait;
}